DROP PROCEDURE IF EXISTS sp_listarProductos;

delimiter $
CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_listarProductos`(IN `p_idProducto` INT, IN `p_idCategoria` INT, IN `p_idSubcategoria` INT, IN `p_idClase` INT, IN `p_tipoOperacion` INT)
BEGIN    
	IF p_tipoOperacion = 1 THEN    
    
		SELECT  
				P.idProducto,            
				CONCAT(C.abreviatura, P.codigo) AS codigo,
				P.nombre,
				CA.idCategoria,
				CA.nombre as 'categoria',
				S.idSubCategoria,
				S.nombre as 'subcategoria',
				P.idClase,            
				C.nombre as 'clase', 
                P.stockActual as stock,
                P.valor_unitario,
                P.precio_unitario,
                P.igv_unitario,
				P.marca,
				P.modelo,
				P.cod_fab,
				(CASE WHEN P.activo = 1 THEN 'SI' 
					WHEN P.activo = 0 THEN 'NO' 
				END) AS activo,
                M.descripcion AS unidad_medida_descripcion
		FROM 	PRODUCTO P
				INNER JOIN CLASE C 
					ON C.idClase = P.idClase 
                    and (C.idClase = p_idClase or '0' = p_idClase)
				INNER JOIN SUBCATEGORIA S 
					ON S.idSubcategoria = C.idSubcategoria 
                    and (S.idSubcategoria = p_idSubcategoria or '0' = p_idSubcategoria)
				INNER JOIN CATEGORIA CA 
					ON CA.idCategoria = S.idCategoria and ( CA.idCategoria = p_idCategoria or'0' = p_idCategoria)
				INNER JOIN MULTITABLA M 
					ON M.dep_id = 3 AND P.unidad_medida = M.abrev
        WHERE 	P.anulado = 0
				and P.activo = 1
		ORDER BY P.nombre;
        
    END	IF; 
    
    IF p_tipoOperacion = 2 THEN
		SELECT  
				P.idProducto,            
				CONCAT(C.abreviatura, P.codigo) AS codigo,
				P.nombre,
				CA.idCategoria,
				CA.nombre as 'categoria',
				S.idSubCategoria,
				S.nombre as 'subcategoria',
				P.idClase,            
				C.nombre as 'clase', 
                P.stockActual as stock,
                P.valor_unitario,
                P.precio_unitario,
                P.igv_unitario,
				P.marca,
				P.modelo,
				P.cod_fab,
				(CASE WHEN P.activo = 1 THEN 'SI' 
					WHEN P.activo = 0 THEN 'NO' 
				END) AS activo,
                M.descripcion AS unidad_medida_descripcion
		FROM 	PRODUCTO P
				INNER JOIN CLASE C 
					ON C.idClase = P.idClase 
                    and (C.idClase = p_idClase or '0' = p_idClase)
				INNER JOIN SUBCATEGORIA S 
					ON S.idSubcategoria = C.idSubcategoria 
                    and (S.idSubcategoria = p_idSubcategoria or '0' = p_idSubcategoria)
				INNER JOIN CATEGORIA CA 
					ON CA.idCategoria = S.idCategoria and ( CA.idCategoria = p_idCategoria or'0' = p_idCategoria)
				INNER JOIN MULTITABLA M 
					ON M.dep_id = 3 AND P.unidad_medida = M.abrev
        WHERE 	P.anulado = 0
				and P.activo = 1 and P.aplicaVenta = 1
		ORDER BY P.nombre;
        
    END	IF;
END
$